#****************************************************************************
#
# SPDX-License-Identifier: MIT-0
# SPDX-FileCopyrightText: Copyright (C) 2025 Altera Corporation
#
#****************************************************************************
#
# Sample SDC for Agilex GHRD.
#
#****************************************************************************

set_time_format -unit ns -decimal_places 3

# 100MHz board input clock, 133.3333MHz for EMIF refclk
create_clock -name MAIN_CLOCK -period 10 [get_ports fpga_clk_100[0]]
create_clock -name EMIF_REF_CLOCK -period 7.5 [get_ports emif_hps_pll_ref_clk]

create_clock -name PCS_CLOCK -period 8 [get_ports enet_refclk]

# sourcing JTAG related SDC
source ./jtag.sdc


# FPGA IO port constraints
set_false_path -from [get_ports {fpga_button_pio[0]}] -to *
set_false_path -from [get_ports {fpga_button_pio[1]}] -to *
set_false_path -from [get_ports {fpga_button_pio[2]}] -to *
set_false_path -from [get_ports {fpga_button_pio[3]}] -to *
set_false_path -from [get_ports {fpga_dipsw_pio[0]}] -to *
set_false_path -from [get_ports {fpga_dipsw_pio[1]}] -to *
set_false_path -from [get_ports {fpga_dipsw_pio[2]}] -to *
set_false_path -from [get_ports {fpga_dipsw_pio[3]}] -to *
set_false_path -from * -to [get_ports {fpga_led_pio[0]}]
set_false_path -from * -to [get_ports {fpga_led_pio[1]}]
set_false_path -from * -to [get_ports {fpga_led_pio[2]}]
set_false_path -from * -to [get_ports {fpga_led_pio[3]}]

set_output_delay -clock MAIN_CLOCK 5 [get_ports {fpga_led_pio[0]}] -add_delay
set_output_delay -clock MAIN_CLOCK 5 [get_ports {fpga_led_pio[1]}] -add_delay
set_output_delay -clock MAIN_CLOCK 5 [get_ports {fpga_led_pio[2]}] -add_delay
set_output_delay -clock MAIN_CLOCK 5 [get_ports {fpga_led_pio[3]}] -add_delay


set_max_skew -to [get_ports "emac2_mdc"] 2
set_max_skew -to [get_ports "emac2_mdio"] 2

set_false_path -from * -to [ get_ports emac1_phy_rst_n ]
set_output_delay -clock MAIN_CLOCK 5 [ get_ports emac1_phy_rst_n ] -add_delay
set_false_path -from * -to [ get_ports emac2_phy_rst_n ]
set_output_delay -clock MAIN_CLOCK 5 [ get_ports emac2_phy_rst_n ] -add_delay
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile0|tx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx~aib_tx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile0|tx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx|pld_pcs_tx_clk_out1_dcm}] -add
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile1|tx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx~aib_tx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile1|tx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx|pld_pcs_tx_clk_out1_dcm}] -add
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile0|tx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx~aib_tx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile0|tx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx|pld_pcs_tx_clk_out1_dcm}] -add
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile1|tx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx~aib_tx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile1|tx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_tx.inst_ct1_hssi_pldadapt_tx|pld_pcs_tx_clk_out1_dcm}] -add

create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile0|rx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx~aib_rx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile0|rx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx|pld_pcs_rx_clk_out1_dcm}] -add
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile1|rx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx~aib_rx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|profile1|rx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_1|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx|pld_pcs_rx_clk_out1_dcm}] -add
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile0|rx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx~aib_rx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile0|rx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx|pld_pcs_rx_clk_out1_dcm}] -add
create_generated_clock -name {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile1|rx_clkout|ch0} -source [get_registers {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx~aib_rx_internal_div.reg}] -master_clock {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|profile1|rx_pcs_x2_clk|ch0} [get_pins {soc_inst|hps_mge|alt_mge_phy_2|alt_mge_phy_inst|alt_mge_xcvr_native|g_xcvr_native_insts[0].ct2_xcvr_native_inst|inst_ct2_xcvr_channel_multi|gen_rev.ct2_xcvr_channel_inst|gen_ct1_hssi_pldadapt_rx.inst_ct1_hssi_pldadapt_rx|pld_pcs_rx_clk_out1_dcm}] -add

set_clock_groups -asynchronous -group [get_clocks {*tx_clkout*}] -group [get_clocks {*rx_clkout*}]


set_false_path -from [get_ports {fpga_reset_n[0]}] -to *

set_false_path -from * -to {soc_inst|rst_controller_*altera_reset_synchronizer_int_chain[1]}


