//****************************************************************************
//
// SPDX-License-Identifier: MIT-0
// SPDX-FileCopyrightText: Copyright (C) 2025 Altera Corporation
//
//****************************************************************************
// This is a generated system top level RTL file. 



module ghrd_s10_top (
// Clock and Reset
input  wire [1-1:0]  fpga_clk_100,
input  wire [1-1:0]  fpga_reset_n,
output wire [4-1:0]  fpga_led_pio,
input  wire [4-1:0]  fpga_dipsw_pio,
input  wire [4-1:0]  fpga_button_pio,
//HPS
// HPS EMIF
output wire [0:0]    emif_hps_mem_mem_ck,
output wire [0:0]    emif_hps_mem_mem_ck_n,
output wire [16:0]   emif_hps_mem_mem_a,
output wire [0:0]    emif_hps_mem_mem_act_n,
output wire [1:0]    emif_hps_mem_mem_ba,
output wire [0:0]    emif_hps_mem_mem_bg,
output wire [0:0]    emif_hps_mem_mem_cke,
output wire [0:0]    emif_hps_mem_mem_cs_n,
output wire [0:0]    emif_hps_mem_mem_odt,
output wire [0:0]    emif_hps_mem_mem_reset_n,
output wire [0:0]    emif_hps_mem_mem_par,
input  wire [0:0]    emif_hps_mem_mem_alert_n,
input  wire          emif_hps_oct_oct_rzqin,
input  wire          emif_hps_pll_ref_clk,
inout  wire [9-1:0]  emif_hps_mem_mem_dbi_n,
inout  wire [72-1:0] emif_hps_mem_mem_dq,
inout  wire [9-1:0]  emif_hps_mem_mem_dqs,
inout  wire [9-1:0]  emif_hps_mem_mem_dqs_n,
output wire          hps_emac2_TX_CLK,       
input  wire          hps_emac2_RX_CLK,      
output wire          hps_emac2_TX_CTL,
input  wire          hps_emac2_RX_CTL,      
output wire          hps_emac2_TXD0,       
output wire          hps_emac2_TXD1,
input  wire          hps_emac2_RXD0,     
input  wire          hps_emac2_RXD1, 
output wire          hps_emac2_TXD2,        
output wire          hps_emac2_TXD3,
input  wire          hps_emac2_RXD2,        
input  wire          hps_emac2_RXD3,
inout  wire          hps_emac2_MDIO,         
output wire          hps_emac2_MDC,
input  wire          hps_uart0_RX,       
output wire          hps_uart0_TX, 
inout  wire          hps_i2c1_SDA,        
inout  wire          hps_i2c1_SCL, 
output wire          hps_nand_ALE,
output wire          hps_nand_CE_N,
output wire          hps_nand_CLE,
output wire          hps_nand_RE_N,
input  wire          hps_nand_RB,
output wire          hps_nand_WP_N,
output wire          hps_nand_WE_N,
inout  wire          hps_nand_ADQ0,
inout  wire          hps_nand_ADQ1,
inout  wire          hps_nand_ADQ2,
inout  wire          hps_nand_ADQ3,
inout  wire          hps_nand_ADQ4,
inout  wire          hps_nand_ADQ5,
inout  wire          hps_nand_ADQ6,
inout  wire          hps_nand_ADQ7,
inout  wire          hps_nand_ADQ8,
inout  wire          hps_nand_ADQ9,
inout  wire          hps_nand_ADQ10,
inout  wire          hps_nand_ADQ11,
inout  wire          hps_nand_ADQ12,
inout  wire          hps_nand_ADQ13,
inout  wire          hps_nand_ADQ14,
inout  wire          hps_nand_ADQ15,
inout  wire          hps_gpio1_io0,
inout  wire          hps_gpio1_io1,
inout  wire          hps_gpio1_io4,
inout  wire          hps_gpio1_io5,
inout  wire          hps_gpio1_io10,
inout  wire          hps_gpio1_io11,
input  wire          enet_refclk,
input  wire          emac1_sgmii_rxp,       
output wire          emac1_sgmii_txp,       
inout  wire          emac1_mdio,
output wire          emac1_mdc,
input  wire          emac1_phy_irq,
output wire          emac1_phy_rst_n,
input  wire          emac2_sgmii_rxp,       
output wire          emac2_sgmii_txp,       
inout  wire          emac2_mdio,
output wire          emac2_mdc,
input  wire          emac2_phy_irq,
output wire          emac2_phy_rst_n,
input  wire          hps_ref_clk
);

wire         system_clk_100;
wire         system_clk_100_internal;
wire         ninit_done;
wire         src_reset_n;
wire         system_reset_n;
wire         system_reset_sync;
wire         h2f_reset;
assign system_reset_n = fpga_reset_n & src_reset_n & ~h2f_reset & ~ninit_done;

altera_reset_synchronizer #(
    .ASYNC_RESET (1),
    .DEPTH       (2)
) sys_rst_inst (
    .reset_in  (~system_reset_n),
    .clk       (system_clk_100),
    .reset_out (system_reset_sync)
);


wire emac1_led_panel_link;
wire emac1_led_link;
wire emac1_led_an;
wire xcvr_reset_1_tx_ready;
wire xcvr_reset_1_rx_ready;
wire emac2_led_panel_link;
wire emac2_led_link;
wire emac2_led_an;
wire xcvr_reset_2_tx_ready;
wire xcvr_reset_2_rx_ready;
wire [12:0] mge_led_pio;

wire fpll_1G_pll_locked;
wire fpll_1G_mcgb_serial_clk;

wire [3:0]  mge_rcfg_pio;
wire enet_pll_locked;



assign system_clk_100   = fpga_clk_100;

assign system_clk_100_internal  = system_clk_100;

wire [3:0]     fpga_debounced_buttons;
wire [2:0]     fpga_led_internal;
wire           heartbeat_led;
reg  [22:0]    heartbeat_count;
assign fpga_led_pio = {heartbeat_led,fpga_led_internal};
assign heartbeat_led = ~heartbeat_count[22];

wire [31:0]    f2h_irq1_irq;


wire emac1_mdi_i, emac1_mdo_oe, emac1_mdo_o;
assign emac1_mdio  = emac1_mdo_oe ? emac1_mdo_o : 1'bz;
assign emac1_mdi_i = emac1_mdio;

assign emac1_phy_rst_n = ~system_reset_sync;
wire emac2_mdi_i, emac2_mdo_oe, emac2_mdo_o;
assign emac2_mdio  = emac2_mdo_oe ? emac2_mdo_o : 1'bz;
assign emac2_mdi_i = emac2_mdio;

assign emac2_phy_rst_n = ~system_reset_sync;

assign mge_led_pio[2:0] = {emac1_led_panel_link, emac1_led_link, emac1_led_an};
assign mge_led_pio[4:3] = {xcvr_reset_1_rx_ready, xcvr_reset_1_tx_ready};
assign mge_led_pio[5] = fpll_1G_pll_locked;
assign mge_led_pio[6] = 1'b0;
assign mge_led_pio[7] = 1'b0;
assign mge_led_pio[10:8] = {emac2_led_panel_link, emac2_led_link, emac2_led_an};
assign mge_led_pio[12:11] = {xcvr_reset_2_rx_ready, xcvr_reset_2_tx_ready};


wire [42:0]    stm_hw_events;

assign stm_hw_events    = 43'b0;


assign f2h_irq1_irq    = {30'b0, ~emac2_phy_irq, ~emac1_phy_irq};


// Qsys Top module
qsys_top soc_inst (
.src_prb_rst_sources_source             (src_reset_n),
.reset_reset_n                          (~system_reset_sync), 
.clk_100_clk                            (system_clk_100_internal),
.ninit_done_ninit_done                  (ninit_done),
.led_pio_external_connection_in_port    (fpga_led_internal),                    
.led_pio_external_connection_out_port   (fpga_led_internal),
.dipsw_pio_external_connection_export   (fpga_dipsw_pio), 
.button_pio_external_connection_export  (fpga_debounced_buttons), 
.s10_hps_f2h_stm_hw_events_stm_hwevents (stm_hw_events),     
.emif_hps_pll_ref_clk_clk               (emif_hps_pll_ref_clk),   
.emif_hps_mem_mem_ck                    (emif_hps_mem_mem_ck),   
.emif_hps_mem_mem_ck_n                  (emif_hps_mem_mem_ck_n),  
.emif_hps_mem_mem_a                     (emif_hps_mem_mem_a),       
.emif_hps_mem_mem_act_n                 (emif_hps_mem_mem_act_n),   
.emif_hps_mem_mem_ba                    (emif_hps_mem_mem_ba),      
.emif_hps_mem_mem_bg                    (emif_hps_mem_mem_bg),      
.emif_hps_mem_mem_cke                   (emif_hps_mem_mem_cke),    
.emif_hps_mem_mem_cs_n                  (emif_hps_mem_mem_cs_n),    
.emif_hps_mem_mem_odt                   (emif_hps_mem_mem_odt),     
.emif_hps_mem_mem_reset_n               (emif_hps_mem_mem_reset_n),
.emif_hps_mem_mem_par                   (emif_hps_mem_mem_par),          
.emif_hps_mem_mem_alert_n               (emif_hps_mem_mem_alert_n),    
.emif_hps_mem_mem_dqs                   (emif_hps_mem_mem_dqs),       
.emif_hps_mem_mem_dqs_n                 (emif_hps_mem_mem_dqs_n),     
.emif_hps_mem_mem_dq                    (emif_hps_mem_mem_dq), 
.emif_hps_mem_mem_dbi_n                 (emif_hps_mem_mem_dbi_n), 
.emif_hps_oct_oct_rzqin                 (emif_hps_oct_oct_rzqin), 
.hps_io_hps_io_phery_emac2_TX_CLK       (hps_emac2_TX_CLK),      
.hps_io_hps_io_phery_emac2_RX_CLK       (hps_emac2_RX_CLK),  
.hps_io_hps_io_phery_emac2_TX_CTL       (hps_emac2_TX_CTL),     
.hps_io_hps_io_phery_emac2_RX_CTL       (hps_emac2_RX_CTL),  
.hps_io_hps_io_phery_emac2_TXD0         (hps_emac2_TXD0),        
.hps_io_hps_io_phery_emac2_TXD1         (hps_emac2_TXD1),  
.hps_io_hps_io_phery_emac2_RXD0         (hps_emac2_RXD0),   
.hps_io_hps_io_phery_emac2_RXD1         (hps_emac2_RXD1),     
.hps_io_hps_io_phery_emac2_TXD2         (hps_emac2_TXD2),      
.hps_io_hps_io_phery_emac2_TXD3         (hps_emac2_TXD3),  
.hps_io_hps_io_phery_emac2_RXD2         (hps_emac2_RXD2),     
.hps_io_hps_io_phery_emac2_RXD3         (hps_emac2_RXD3),   
.hps_io_hps_io_phery_emac2_MDIO         (hps_emac2_MDIO),  
.hps_io_hps_io_phery_emac2_MDC          (hps_emac2_MDC),  
.hps_io_hps_io_phery_nand_ALE           (hps_nand_ALE),
.hps_io_hps_io_phery_nand_CE_N          (hps_nand_CE_N),
.hps_io_hps_io_phery_nand_CLE           (hps_nand_CLE),
.hps_io_hps_io_phery_nand_RE_N          (hps_nand_RE_N),
.hps_io_hps_io_phery_nand_RB            (hps_nand_RB),
.hps_io_hps_io_phery_nand_WP_N          (hps_nand_WP_N),
.hps_io_hps_io_phery_nand_WE_N          (hps_nand_WE_N),
.hps_io_hps_io_phery_nand_ADQ0          (hps_nand_ADQ0),
.hps_io_hps_io_phery_nand_ADQ1          (hps_nand_ADQ1),
.hps_io_hps_io_phery_nand_ADQ2          (hps_nand_ADQ2),
.hps_io_hps_io_phery_nand_ADQ3          (hps_nand_ADQ3),
.hps_io_hps_io_phery_nand_ADQ4          (hps_nand_ADQ4),
.hps_io_hps_io_phery_nand_ADQ5          (hps_nand_ADQ5),
.hps_io_hps_io_phery_nand_ADQ6          (hps_nand_ADQ6),
.hps_io_hps_io_phery_nand_ADQ7          (hps_nand_ADQ7),
.hps_io_hps_io_phery_nand_ADQ8          (hps_nand_ADQ8),
.hps_io_hps_io_phery_nand_ADQ9          (hps_nand_ADQ9),
.hps_io_hps_io_phery_nand_ADQ10         (hps_nand_ADQ10),
.hps_io_hps_io_phery_nand_ADQ11         (hps_nand_ADQ11),
.hps_io_hps_io_phery_nand_ADQ12         (hps_nand_ADQ12),
.hps_io_hps_io_phery_nand_ADQ13         (hps_nand_ADQ13),
.hps_io_hps_io_phery_nand_ADQ14         (hps_nand_ADQ14),
.hps_io_hps_io_phery_nand_ADQ15         (hps_nand_ADQ15),
.hps_io_hps_io_phery_i2c1_SDA           (hps_i2c1_SDA),     
.hps_io_hps_io_phery_i2c1_SCL           (hps_i2c1_SCL),
.hps_io_hps_io_phery_uart0_RX           (hps_uart0_RX),          
.hps_io_hps_io_phery_uart0_TX           (hps_uart0_TX), 
.hps_io_hps_io_gpio_gpio1_io0           (hps_gpio1_io0),
.hps_io_hps_io_gpio_gpio1_io1           (hps_gpio1_io1),
.hps_io_hps_io_gpio_gpio1_io4           (hps_gpio1_io4),
.hps_io_hps_io_gpio_gpio1_io5           (hps_gpio1_io5),
.hps_io_hps_io_gpio_gpio1_io10           (hps_gpio1_io10),
.hps_io_hps_io_gpio_gpio1_io11           (hps_gpio1_io11),
.f2h_irq1_irq                           (f2h_irq1_irq),
.enet_refclk_clk                           (enet_refclk),
.mge_rcfg_reset_sink_reset_n               (fpll_1G_pll_locked),
.mge_led_pio_export                        (mge_led_pio),
.mge_rcfg_pio_export                       (mge_rcfg_pio),
.mge_rcfg_status_export                    (mge_rcfg_pio),
.enet_iopll_locked_export                  (enet_pll_locked),
.fpll_1G_mcgb_serial_clk_clk               (fpll_1G_mcgb_serial_clk),
.fpll_1G_pll_locked_pll_locked             (fpll_1G_pll_locked),
.emac1_led_an_export                    (emac1_led_an),
.emac1_led_char_err_export              (),
.emac1_led_disp_err_export              (),
.emac1_led_link_export                  (emac1_led_link),
.emac1_led_panel_link_export            (emac1_led_panel_link),
.emac1_mdc_clk                          (emac1_mdc),
.emac1_mdio_gmii_mdi_i                  (emac1_mdi_i),
.emac1_mdio_gmii_mdo_o                  (emac1_mdo_o),
.emac1_mdio_gmii_mdo_o_e                (emac1_mdo_oe),
.emac1_mge_tx_serial_clk_clk            ({fpll_1G_mcgb_serial_clk,1'b0}),            //   input,   width = 2,        emac1_mge_tx_serial_clk.clk
.emac1_ptp_ptp_aux_ts_trig_i            (1'b0),
.emac1_ptp_ptp_pps_o                    (),
.emac1_ptp_ptp_tstmp_data               (),
.emac1_ptp_ptp_tstmp_en                 (),
.emac1_rx_serial_data_rx_serial_data    (emac1_sgmii_rxp),
.emac1_tx_serial_data_tx_serial_data    (emac1_sgmii_txp),
.gmii_adapter1_pll_locked_export        (enet_pll_locked),
.xcvr_reset_1_pll_locked_pll_locked     ({fpll_1G_pll_locked, 1'b0}),
.xcvr_reset_1_tx_ready_tx_ready         (xcvr_reset_1_tx_ready),
.xcvr_reset_1_rx_ready_rx_ready         (xcvr_reset_1_rx_ready),
.emac2_led_an_export                    (emac2_led_an),
.emac2_led_char_err_export              (),
.emac2_led_disp_err_export              (),
.emac2_led_link_export                  (emac2_led_link),
.emac2_led_panel_link_export            (emac2_led_panel_link),
.emac2_mdc_clk                          (emac2_mdc),
.emac2_mdio_gmii_mdi_i                  (emac2_mdi_i),
.emac2_mdio_gmii_mdo_o                  (emac2_mdo_o),
.emac2_mdio_gmii_mdo_o_e                (emac2_mdo_oe),
.emac2_mge_tx_serial_clk_clk            ({fpll_1G_mcgb_serial_clk,1'b0}),            //   input,   width = 2,        emac1_mge_tx_serial_clk.clk
.emac2_ptp_ptp_aux_ts_trig_i            (1'b0),
.emac2_ptp_ptp_pps_o                    (),
.emac2_ptp_ptp_tstmp_data               (),
.emac2_ptp_ptp_tstmp_en                 (),
.emac2_rx_serial_data_rx_serial_data    (emac2_sgmii_rxp),
.emac2_tx_serial_data_tx_serial_data    (emac2_sgmii_txp),
.gmii_adapter2_pll_locked_export        (enet_pll_locked),
.xcvr_reset_2_pll_locked_pll_locked     ({fpll_1G_pll_locked, 1'b0}),
.xcvr_reset_2_tx_ready_tx_ready         (xcvr_reset_2_tx_ready),
.xcvr_reset_2_rx_ready_rx_ready         (xcvr_reset_2_rx_ready),


.h2f_reset_reset                        (h2f_reset),
.hps_io_hps_io_hps_ocs_clk              (hps_ref_clk)
);  


// Debounce logic to clean out glitches within 1ms
debounce debounce_inst (
.clk          (system_clk_100_internal),
.reset_n      (~system_reset_sync),  
.data_in      (fpga_button_pio),
.data_out     (fpga_debounced_buttons)
);
defparam debounce_inst.WIDTH = 4;
defparam debounce_inst.POLARITY = "LOW";
defparam debounce_inst.TIMEOUT = 10000;               // at 100Mhz this is a debounce time of 1ms
defparam debounce_inst.TIMEOUT_WIDTH = 32;            // ceil(log2(TIMEOUT))

always @(posedge system_clk_100_internal or posedge system_reset_sync) begin
  if (system_reset_sync)
    heartbeat_count <= 23'd0;
  else
    heartbeat_count <= heartbeat_count + 23'd1;
end


endmodule


