#****************************************************************************
#
# SPDX-License-Identifier: MIT-0
# SPDX-FileCopyrightText: Copyright (C) 2025 Altera Corporation
#
#****************************************************************************
#
# Sample SDC for Agilex GHRD.
#
#****************************************************************************

set_time_format -unit ns -decimal_places 3

# 100MHz board input clock, 133.3333MHz for EMIF refclk
create_clock -name MAIN_CLOCK -period 10 [get_ports fpga_clk_100[0]]
create_clock -name EMIF_REF_CLOCK -period 6.0 [get_ports emif_hps_pll_ref_clk]

set_false_path -from [get_ports {fpga_reset_n[0]}]

# sourcing JTAG related SDC
source ./jtag.sdc

# FPGA IO port constraints
create_clock -name SGPIO_CLOCK -period 1MHz [get_ports fpga_sgpio_clk]
set_false_path -from [get_ports {fpga_button_pio[0]}] -to *
set_false_path -from [get_ports {fpga_button_pio[1]}] -to *
set_false_path -from [get_ports {fpga_sgpi}] -to *
set_false_path -from [get_ports {fpga_sgpio_sync}] -to *
set_false_path -from * -to [get_ports {fpga_sgpo}]
set_output_delay -clock SGPIO_CLOCK 1 [get_ports fpga_sgpo]



